/*
 * MainFrame.java
 *
 * Created on 29 maart 2007, 21:38
 */

package iliadmanifestcreator;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DnDConstants;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

/**
 *
 * @author  Bert
 */
public class MainFrame extends javax.swing.JFrame implements DropTargetListener {
    final Color[] iLiadColors = {new Color(0x000000), new Color(0x111111), new Color(0x222222), new Color(0x333333), new Color(0x444444), new Color(0x555555), new Color(0x666666), new Color(0x777777), new Color(0x888888), new Color(0x999999), new Color(0xAAAAAA), new Color(0xBBBBBB), new Color(0xCCCCCC), new Color(0xDDDDDD), new Color(0xEEEEEE), new Color(0xFFFFFF)};
    ILiadManifest imCurrentManifest;
    String strCurrentManifest;
    boolean isExistingManifest;
    
    DropTarget dtSource, dtImage;
    
    /** Creates new form MainFrame */
    public MainFrame() {
        initComponents();
        showWarning(false);
        lblImageExampleNote.setVisible(false);
        btnCreateManifest.setEnabled(false);
        
        // This class will handle drop events
        dtSource = new DropTarget(tfSource, this);
        dtImage = new DropTarget(tfImage, this);
    }

    /**
     *Shows either the warning telling this action will move the content to a subdirectory, 
     *or the checkbox 'reset position'.
     *@param bShow If true, show the warning and hides the checkbox.
     */
    protected void showWarning(boolean bShow) {
        lblWarningIcon.setVisible(bShow);
        lblWarning.setVisible(bShow);
        chkResetPosition.setVisible(!bShow);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        pnlSource = new javax.swing.JPanel();
        lblSourceNote = new javax.swing.JLabel();
        lblSource = new javax.swing.JLabel();
        tfSource = new javax.swing.JTextField();
        btnSource = new javax.swing.JButton();
        pnlManifest = new javax.swing.JPanel();
        lblTitle = new javax.swing.JLabel();
        lblDescription = new javax.swing.JLabel();
        lblIcon = new javax.swing.JLabel();
        tfTitle = new javax.swing.JTextField();
        scrDescription = new javax.swing.JScrollPane();
        taDescription = new javax.swing.JTextArea();
        tfImage = new javax.swing.JTextField();
        btnImage = new javax.swing.JButton();
        chkImageResize = new javax.swing.JCheckBox();
        chkImageConvertToGray = new javax.swing.JCheckBox();
        chkFillBackground = new javax.swing.JCheckBox();
        cmbFillBackgroundColor = new javax.swing.JComboBox();
        chkNegative = new javax.swing.JCheckBox();
        lblImageExample = new javax.swing.JLabel();
        lblImageExampleNote = new javax.swing.JLabel();
        lblWarningIcon = new javax.swing.JLabel();
        lblWarning = new javax.swing.JLabel();
        chkResetPosition = new javax.swing.JCheckBox();
        btnCreateManifest = new javax.swing.JButton();
        btnExit = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("iLiad Manifest Creator");
        setResizable(false);
        pnlSource.setBorder(javax.swing.BorderFactory.createTitledBorder("Source"));
        lblSourceNote.setText("<html>Note: If you want to edit a manifest for a directory, make sure to select the directory containing the actual content (NOT the wrapping directory - or it will be wrapped again).</html>");

        lblSource.setLabelFor(tfSource);
        lblSource.setText("Source:");

        btnSource.setText("Browse...");
        btnSource.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnSourceActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout pnlSourceLayout = new org.jdesktop.layout.GroupLayout(pnlSource);
        pnlSource.setLayout(pnlSourceLayout);
        pnlSourceLayout.setHorizontalGroup(
            pnlSourceLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, pnlSourceLayout.createSequentialGroup()
                .addContainerGap()
                .add(pnlSourceLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, lblSourceNote, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 540, Short.MAX_VALUE)
                    .add(pnlSourceLayout.createSequentialGroup()
                        .add(lblSource)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(tfSource, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 414, Short.MAX_VALUE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(btnSource)))
                .addContainerGap())
        );
        pnlSourceLayout.setVerticalGroup(
            pnlSourceLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(pnlSourceLayout.createSequentialGroup()
                .add(lblSourceNote)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(pnlSourceLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(tfSource, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(btnSource)
                    .add(lblSource))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        pnlManifest.setBorder(javax.swing.BorderFactory.createTitledBorder("Manifest"));
        lblTitle.setLabelFor(tfTitle);
        lblTitle.setText("Title:");

        lblDescription.setLabelFor(taDescription);
        lblDescription.setText("Description:");

        lblIcon.setLabelFor(tfImage);
        lblIcon.setText("Image:");

        scrDescription.setHorizontalScrollBarPolicy(javax.swing.ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
        taDescription.setColumns(20);
        taDescription.setFont(new java.awt.Font("Tahoma", 0, 11));
        taDescription.setRows(3);
        taDescription.setMargin(new java.awt.Insets(1, 5, 2, 4));
        scrDescription.setViewportView(taDescription);

        tfImage.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                tfImageActionPerformed(evt);
            }
        });

        btnImage.setText("Browse...");
        btnImage.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnImageActionPerformed(evt);
            }
        });

        chkImageResize.setSelected(true);
        chkImageResize.setText("Resize to 69 x 93 pixels");
        chkImageResize.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        chkImageResize.setMargin(new java.awt.Insets(0, 0, 0, 0));

        chkImageConvertToGray.setSelected(true);
        chkImageConvertToGray.setText("Convert to ILiad grayscale");
        chkImageConvertToGray.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        chkImageConvertToGray.setMargin(new java.awt.Insets(0, 0, 0, 0));
        chkImageConvertToGray.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                chkImageConvertToGrayActionPerformed(evt);
            }
        });

        chkFillBackground.setText("Fill background with");
        chkFillBackground.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        chkFillBackground.setMargin(new java.awt.Insets(0, 0, 0, 0));
        chkFillBackground.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                chkFillBackgroundActionPerformed(evt);
            }
        });

        cmbFillBackgroundColor.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "#000000 (Black)", "#111111", "#222222", "#333333", "#444444", "#555555 (Dark Grey)", "#666666", "#777777", "#888888", "#999999", "#AAAAAA (Light Grey)", "#BBBBBB", "#CCCCCC", "#DDDDDD", "#EEEEEE", "#FFFFFF (White)" }));
        cmbFillBackgroundColor.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cmbFillBackgroundColorActionPerformed(evt);
            }
        });

        chkNegative.setText("Negative");
        chkNegative.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        chkNegative.setMargin(new java.awt.Insets(0, 0, 0, 0));
        chkNegative.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                chkNegativeActionPerformed(evt);
            }
        });

        lblImageExample.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lblImageExample.setIcon(new javax.swing.ImageIcon(getClass().getResource("/iliadmanifestcreator/res/cross.png")));
        lblImageExample.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 255)));
        lblImageExample.setMaximumSize(new java.awt.Dimension(69, 93));
        lblImageExample.setMinimumSize(new java.awt.Dimension(69, 93));
        lblImageExample.setPreferredSize(new java.awt.Dimension(69, 93));

        lblImageExampleNote.setText("<html>Note: the image preview is  the 69 x 93 px format.</html>");

        org.jdesktop.layout.GroupLayout pnlManifestLayout = new org.jdesktop.layout.GroupLayout(pnlManifest);
        pnlManifest.setLayout(pnlManifestLayout);
        pnlManifestLayout.setHorizontalGroup(
            pnlManifestLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(pnlManifestLayout.createSequentialGroup()
                .addContainerGap()
                .add(pnlManifestLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(lblTitle)
                    .add(lblDescription)
                    .add(lblIcon))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(pnlManifestLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, scrDescription, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 477, Short.MAX_VALUE)
                    .add(tfTitle, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 477, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, pnlManifestLayout.createSequentialGroup()
                        .add(pnlManifestLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                            .add(org.jdesktop.layout.GroupLayout.LEADING, pnlManifestLayout.createSequentialGroup()
                                .add(lblImageExample, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 69, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(pnlManifestLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                    .add(chkNegative)
                                    .add(pnlManifestLayout.createSequentialGroup()
                                        .add(chkFillBackground)
                                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                        .add(cmbFillBackgroundColor, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 111, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                                    .add(chkImageResize)
                                    .add(chkImageConvertToGray))
                                .add(47, 47, 47))
                            .add(tfImage, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 392, Short.MAX_VALUE))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(btnImage))
                    .add(lblImageExampleNote, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 254, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );
        pnlManifestLayout.setVerticalGroup(
            pnlManifestLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(pnlManifestLayout.createSequentialGroup()
                .add(pnlManifestLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(lblTitle)
                    .add(tfTitle, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(pnlManifestLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(lblDescription)
                    .add(scrDescription, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 54, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(pnlManifestLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(tfImage, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(lblIcon)
                    .add(btnImage))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(pnlManifestLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(pnlManifestLayout.createSequentialGroup()
                        .add(chkImageResize)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(chkImageConvertToGray)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(pnlManifestLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                            .add(chkFillBackground)
                            .add(cmbFillBackgroundColor, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(chkNegative))
                    .add(lblImageExample, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 93, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(lblImageExampleNote, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        lblWarningIcon.setIcon(new javax.swing.ImageIcon(getClass().getResource("/iliadmanifestcreator/res/exclamation.png")));

        lblWarning.setText("This will cause the file/directory to be moved to a subdirectory!");

        chkResetPosition.setText("Reset current position");
        chkResetPosition.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        chkResetPosition.setMargin(new java.awt.Insets(0, 0, 0, 0));

        btnCreateManifest.setText("Create manifest");
        btnCreateManifest.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnCreateManifestActionPerformed(evt);
            }
        });

        btnExit.setText("Exit");
        btnExit.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnExitActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(pnlManifest, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(pnlSource, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(layout.createSequentialGroup()
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                            .add(layout.createSequentialGroup()
                                .add(10, 10, 10)
                                .add(lblWarningIcon)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(lblWarning)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(chkResetPosition)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                            .add(layout.createSequentialGroup()
                                .add(btnCreateManifest)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)))
                        .add(btnExit)))
                .addContainerGap())
        );

        layout.linkSize(new java.awt.Component[] {btnCreateManifest, btnExit}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(pnlSource, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(pnlManifest, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(lblWarningIcon)
                    .add(lblWarning)
                    .add(chkResetPosition))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, 20, Short.MAX_VALUE)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(btnExit)
                    .add(btnCreateManifest))
                .addContainerGap())
        );
        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void tfImageActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_tfImageActionPerformed
        setImage(tfImage.getText());
    }//GEN-LAST:event_tfImageActionPerformed

    private void cmbFillBackgroundColorActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cmbFillBackgroundColorActionPerformed
        //refresh image if necessary
        if (chkFillBackground.isSelected())
            setImage(tfImage.getText());
    }//GEN-LAST:event_cmbFillBackgroundColorActionPerformed

    private void chkNegativeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_chkNegativeActionPerformed
        //refresh image
        setImage(tfImage.getText());
    }//GEN-LAST:event_chkNegativeActionPerformed

    private void chkFillBackgroundActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_chkFillBackgroundActionPerformed
        //refresh image
        setImage(tfImage.getText());
    }//GEN-LAST:event_chkFillBackgroundActionPerformed

    private void chkImageConvertToGrayActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_chkImageConvertToGrayActionPerformed
        //refresh image
        setImage(tfImage.getText());
    }//GEN-LAST:event_chkImageConvertToGrayActionPerformed

    private void btnCreateManifestActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnCreateManifestActionPerformed
        if (imCurrentManifest == null || (isExistingManifest && strCurrentManifest == null))
            return;

        File fileSource = new File(tfSource.getText());
        if (!fileSource.exists())
            return;
        
        //move file/dir & create manifest if necessary
        String strContentSrc = fileSource.isFile() ? imCurrentManifest.strStartPage : imCurrentManifest.strDirectoryContent;
        File dirWithContent = null; //dir with image, manifest and content dir/file
        if (!isExistingManifest) {
            if (fileSource.isFile()) {
                //create paths
                dirWithContent = new File(fileSource.getParent() + File.separator + getFileTitle(fileSource) + File.separator);
                strContentSrc = fileSource.getName();
            } else {
                //create paths
                dirWithContent = new File(fileSource.getAbsolutePath() + File.separator);
                strContentSrc = "dir_content";
                
                //moving a dir to its own subdir will fail, so I use a (little dirty) workaround:
                // first rename (move) the dir to something else, then rename it again to the subdir
                File fileTempDir = new File(dirWithContent.getParentFile(), "__temp_dir_ILiadManifestCreator");
                if (fileSource.renameTo(fileTempDir)) {
                    fileSource = fileTempDir;
                } else {
                    JOptionPane.showMessageDialog(this, "Error while moving the directory", "Error", JOptionPane.ERROR_MESSAGE);
                    return;
                }
            }
                    
            //set manifest path
            strCurrentManifest = new File(dirWithContent, "manifest.xml").getAbsolutePath();
                
            //create subdir
            File fileSourceMoved = new File(dirWithContent, strContentSrc);
            if (!fileSourceMoved.getParentFile().mkdirs()) {
                JOptionPane.showMessageDialog(this, "Error while creating the new directory", "Error", JOptionPane.ERROR_MESSAGE);
                return;
            }

            //move file dir
            if (fileSource.renameTo(fileSourceMoved)) {
                showWarning(false); //files are moved
                tfSource.setText(fileSourceMoved.getAbsolutePath());
                fileSource = fileSourceMoved;
            } else {
                JOptionPane.showMessageDialog(this, "Error while moving directory", "Error", JOptionPane.ERROR_MESSAGE);
                return;
            }
        } else {
            dirWithContent = new File(strCurrentManifest).getParentFile();
        }


        //create image if necessary
        File fileImage = new File(tfImage.getText());
        String strImage = null;
        if (fileImage != null && fileImage.exists()) {
            //save only the filename (not the path)
            strImage = fileImage.getName();

            //create the image
            BufferedImage img = ImageTools.readImage(fileImage);
            if (chkImageResize.isSelected())
                img = ImageTools.scaleImage(img, 69, 93);
            if (chkNegative.isSelected())
                img = ImageTools.negative(img);
            if (chkFillBackground.isSelected())
                img = ImageTools.replaceAlphaByColor(img, iLiadColors[cmbFillBackgroundColor.getSelectedIndex()]);
            if (chkImageConvertToGray.isSelected())
                img = ImageTools.convertTo4bitGrayScale(img);
            
            //save the image
            String strImageDest = new File(dirWithContent, strImage).getAbsolutePath();
            if (!ImageTools.writeImage(img, "png", strImageDest))
                strImage = null;
        }
        
        //update manifest
        imCurrentManifest.strTitle = tfTitle.getText();
        imCurrentManifest.strDescription = taDescription.getText();
        imCurrentManifest.strImage = strImage;
        if (fileSource.isFile())
            imCurrentManifest.strStartPage = strContentSrc;
        else //directory
            imCurrentManifest.strDirectoryContent = strContentSrc;
        if (isExistingManifest && chkResetPosition.isSelected())
            imCurrentManifest.resetCurrentPosition();
        
        //save it
        if ( !imCurrentManifest.save(strCurrentManifest) ) {
            JOptionPane.showMessageDialog(this, "Error while writing manifest file", "Error", JOptionPane.ERROR_MESSAGE);
            return;
        }

    }//GEN-LAST:event_btnCreateManifestActionPerformed

    private void btnImageActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnImageActionPerformed
        //get the currently entered path
        File fileSource = new File(tfImage.getText());
        //show the file chooser
        JFileChooser fc = new JFileChooser();
        fc.setAcceptAllFileFilterUsed(false);
        fc.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
        fc.setSelectedFile(fileSource);
        FileFilter ff = new FileFilter() {
            public boolean accept(File f) {
                return f.isDirectory() /*we have to accept directories because otherwise browsing is impossible*/
                       || f.getName().toLowerCase().endsWith(".png")
                       || f.getName().toLowerCase().endsWith(".bmp")
                       || f.getName().toLowerCase().endsWith(".jpg")
                       || f.getName().toLowerCase().endsWith(".gif");
            }
            
            public String getDescription() {
                return "Supported icon files";
            }
        };
        fc.setFileFilter(ff);
        int nReturnValue = fc.showOpenDialog(this);
        //set the source
        if (nReturnValue==fc.APPROVE_OPTION && fc.getSelectedFile().isFile()) {
            setImage(fc.getSelectedFile().getAbsolutePath());
        }
    }//GEN-LAST:event_btnImageActionPerformed

    private void btnSourceActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnSourceActionPerformed
        //get the currently entered path
        File fileSource = new File(tfSource.getText());
        //show the file chooser
        JFileChooser fc = new JFileChooser();
        fc.setAcceptAllFileFilterUsed(false);
        fc.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
        fc.setSelectedFile(fileSource);
        int nReturnValue = fc.showOpenDialog(this);
        //set the source
        if (nReturnValue==fc.APPROVE_OPTION) {
            setSource(fc.getSelectedFile().getAbsolutePath());
        }
    }//GEN-LAST:event_btnSourceActionPerformed

    private void btnExitActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnExitActionPerformed
        //post a WINDOW_CLOSING msg to simulate click on 'close' button (in the title bar)
        Toolkit t = Toolkit.getDefaultToolkit();
        EventQueue eq = t.getSystemEventQueue();
        eq.postEvent(new WindowEvent(this, WindowEvent.WINDOW_CLOSING));
    }//GEN-LAST:event_btnExitActionPerformed
    
    /**
     *Sets the source file/directory, reads the manifest if there is already one present, 
     *and updates all fields accordingly.
     *@param strSource Full path to the source.<br>
     *<b>Note:</b> If the source is a directory, the source path has to be the path of the 
     * directory containing the real content, not the wrapping directory (which contains 
     * the manifest and icon).
     */
    private void setSource(String strSource) {
        //open file
        File fileSource = new File(strSource);
        if (!fileSource.exists()) {
            showWarning(false);
            setImage("");
            btnCreateManifest.setEnabled(false);
            return;
        }
        
        //set source
        tfSource.setText(fileSource.getAbsolutePath());
        
        //check if there's already a manifest present
        // AND if that manifest corresponds with this file/dir
        String strManifestInSameDir = fileSource.getParent() + File.separator + "manifest.xml";
        boolean bManifestExists = false;
        if (new File(strManifestInSameDir).isFile()) { //exists & is file
            ILiadManifest imCheck = new ILiadManifest(strManifestInSameDir);
            if (fileSource.isFile())
                bManifestExists = imCheck.strStartPage.equalsIgnoreCase(fileSource.getName());
            else
                bManifestExists = imCheck.strDirectoryContent.equalsIgnoreCase(fileSource.getName());
        }
        
        //open / create manifest
        if (bManifestExists) {
            strCurrentManifest = strManifestInSameDir;
            isExistingManifest = true;
            showWarning(false);
            //parse manifest
            imCurrentManifest = new ILiadManifest(strManifestInSameDir);
            //set display
            tfTitle.setText(imCurrentManifest.strTitle);
            taDescription.setText(imCurrentManifest.strDescription);
            setImage(fileSource.getParent() + File.separator + imCurrentManifest.strImage);
            btnCreateManifest.setText("Save Manifest");
        } else {
            isExistingManifest = false;
            showWarning(true);
            //create new manifest
            imCurrentManifest = new ILiadManifest();
            //set display
            tfTitle.setText(getFileTitle(fileSource));
            taDescription.setText("");
            setImage("");
            btnCreateManifest.setText("Create Manifest");
        }
        
        //enable save button
        btnCreateManifest.setEnabled(true);
    }
    
    /**
     *Get the file title of the given file. This is the filename without extension
     *@param file A java.io.File object
     */
    private String getFileTitle(File file) {
        if (file == null)
            return null;
                
        String strFile = file.getName();
        int nExtPos = strFile.lastIndexOf('.');
        if (nExtPos >= 0)
            return strFile.substring(0, nExtPos);
        else
            return strFile;
    }

    /**
     *Sets the image, updates the preview and shows/hides warnings as necessare
     *@param strImage Full path to the image source
     */
    private void setImage(String strImage) {
        boolean bResize = false;
        if (new File(strImage).isFile()) { //it should exist and be a file
            tfImage.setText(strImage);
            bResize = !lblWarningIcon.isVisible();
            lblImageExampleNote.setVisible(true);
            
            BufferedImage imgOrg = ImageTools.readImage(new File(strImage));
            //always scale the image
            BufferedImage imgPreview = ImageTools.scaleImage(imgOrg, 69, 93);
            if (chkNegative.isSelected())
                imgPreview = ImageTools.negative(imgPreview);
            if (chkFillBackground.isSelected())
                imgPreview = ImageTools.replaceAlphaByColor(imgPreview, iLiadColors[cmbFillBackgroundColor.getSelectedIndex()]);
            if (chkImageConvertToGray.isSelected())
                imgPreview = ImageTools.convertTo4bitGrayScale(imgPreview);
            
            lblImageExample.setIcon(new ImageIcon(imgPreview));
        }
        else {
            tfImage.setText("");
            lblImageExample.setIcon(new ImageIcon(getClass().getResource("/iliadmanifestcreator/res/cross.png")));
            bResize = lblWarningIcon.isVisible();
            lblImageExampleNote.setVisible(false);
        }
        
        if (bResize) {
            pnlManifest.invalidate();
            invalidate();
            pack();
            try {
                Thread.sleep(1000);
            } catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            pack();
        }
    }

    // Drag & drop support
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    public void dragOver(DropTargetDragEvent dtde) {
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public void dragExit(DropTargetEvent dte) {
    }

    public void drop(DropTargetDropEvent dtde) {
        //note: dragging text is supported by swing, so we handle only dragging of files.
        try {
            //Get the dropped object and try to figure out what it is
            Transferable tr = dtde.getTransferable();
            if (tr.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                // Accept copy drops...
                dtde.acceptDrop(DnDConstants.ACTION_COPY);

                // And use the first file in the list
                File file = (File) ((List)tr.getTransferData(DataFlavor.javaFileListFlavor)).get(0);
                if (file != null) {
                    if (dtde.getSource()==dtSource)
                        setSource( file.getAbsolutePath() );
                    else if (dtde.getSource()==dtImage)
                        setImage( file.getAbsolutePath() );
                }

                // If we made it this far, everything worked.
                dtde.dropComplete(true);
            }
        } catch (Exception e) {
            e.printStackTrace();
            dtde.rejectDrop();
        }
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnCreateManifest;
    private javax.swing.JButton btnExit;
    private javax.swing.JButton btnImage;
    private javax.swing.JButton btnSource;
    private javax.swing.JCheckBox chkFillBackground;
    private javax.swing.JCheckBox chkImageConvertToGray;
    private javax.swing.JCheckBox chkImageResize;
    private javax.swing.JCheckBox chkNegative;
    private javax.swing.JCheckBox chkResetPosition;
    private javax.swing.JComboBox cmbFillBackgroundColor;
    private javax.swing.JLabel lblDescription;
    private javax.swing.JLabel lblIcon;
    private javax.swing.JLabel lblImageExample;
    private javax.swing.JLabel lblImageExampleNote;
    private javax.swing.JLabel lblSource;
    private javax.swing.JLabel lblSourceNote;
    private javax.swing.JLabel lblTitle;
    private javax.swing.JLabel lblWarning;
    private javax.swing.JLabel lblWarningIcon;
    private javax.swing.JPanel pnlManifest;
    private javax.swing.JPanel pnlSource;
    private javax.swing.JScrollPane scrDescription;
    private javax.swing.JTextArea taDescription;
    private javax.swing.JTextField tfImage;
    private javax.swing.JTextField tfSource;
    private javax.swing.JTextField tfTitle;
    // End of variables declaration//GEN-END:variables
    
}
